class MHmod expands Mutator config(ut4ever);

function PreBeginPlay ()
{

	Super.PreBeginPlay();

	Level.Game.HUDType = Class'HUD_MH';
	Level.Game.ScoreBoardType=Class'SB_MH';

	Level.Game.GameName = "ut4ever.org MonsterHunt";

	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'MH_DamageMutator'));

	SetTimer(1.0,True);

}

simulated function bool AlwaysKeep(Actor Other)
{

	if ( Other.IsA('Carcass') )
		{
		Carcass(Other).Style = STY_Translucent;
		Carcass(Other).bProjTarget = False;
		Carcass(Other).bBlockPlayers = False;
		}
	if ( Other.IsA('MonsterEnd') )
		{
		MonsterEnd(Other).bHidden = False;
		}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local actor dropped;
local float speed;
local inventory inv;
local weapon weap;
local int X;

	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
		{
		if ( inv.IsA('Weapon') && !inv.IsA('ImpactHammer') && !inv.IsA('ChainSaw') && !inv.IsA('Translocator') )
			{
			weap = Weapon(inv);

			//spawn inventory item to world:
			dropped = Spawn(weap.Class,,,Killed.Location);

			speed = VSize(Killed.Velocity);

			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);

			weap = Weapon(dropped);

			weap.PickupAmmoCount = weap.default.PickupAmmoCount;

			if ( weap != None )
				{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
				}
			}
		Killed.Inventory.Destroy();
		}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

function Timer()
{
local Pawn P;
local Inventory Inv;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			if (P.Health < 500)
				P.Health++;
			for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
				{ 
				if ( Inv.IsA('Weapon') && !Inv.IsA('WarheadLauncher') )
					{
					if ( Weapon(Inv).Ammotype != none )
						{
						if ( Weapon(Inv).Ammotype.AmmoAmount < Weapon(Inv).PickupAmmoCount * 4 )
							{
							if (Weapon(Inv).IsA('minigun2'))
								{
								Weapon(Inv).Ammotype.AmmoAmount += 5;
								if ( Weapon(Inv).Ammotype.AmmoAmount > Weapon(Inv).PickupAmmoCount * 4 )
									{
									Weapon(Inv).Ammotype.AmmoAmount = Weapon(Inv).PickupAmmoCount * 4;
									}
								}
							else
								{
								Weapon(Inv).Ammotype.AmmoAmount++;
								}
							}
						}
					}
				}
			}
		}

}

defaultproperties
{
}


